package ch.frankel.blog.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.validation.model.custom.prop.Person;
import ch.frankel.blog.validation.validator.Capitalized;

public class CustomPropertyValidationTest {

	private Validator validator;

	@Before
	public void setUp() throws Exception {

		validator = Validation.buildDefaultValidatorFactory().getValidator();
	}

	/**
	 * Tests custom validation. Checks there's no violation when
	 * <code>firstName</code> is <code>null</code>.
	 */
	@Test
	public void validatePersonNull() {

		Person person = new Person();

		Set<ConstraintViolation<Person>> violations = validator
				.validate(person);

		assertTrue(violations.isEmpty());
	}

	/**
	 * Tests custom validation. Checks there's a unique violation when
	 * <code>firstName</code> is not capitalized.
	 */
	@Test
	public void validatePersonNotCapitalized() {

		Person person = new Person();

		person.setFirstName("a");

		Set<ConstraintViolation<Person>> violations = validator
				.validate(person);

		assertFalse(violations.isEmpty());
		assertEquals(1, violations.size());

		ConstraintViolation<Person> violation = violations.iterator().next();

		assertEquals("firstName", violation.getPropertyPath().iterator().next()
				.getName());
		assertSame(Capitalized.class, violation.getConstraintDescriptor()
				.getAnnotation().annotationType());
	}
}
